////////////////////////////////////////////////////////////////////////////////
// Double Metaphone (c) 1998, 1999 by Lawrence Philips
//
// Slightly modified by Kevin Atkinson to fix several bugs and 
// to allow it to give back more than 4 characters.
//
//
////////////////////////////////////////////////////////////////////////////////
#include <stdafx.h>
#include <string>

class MString {
public:
	std::string primary;
	std::string secondary;
	std::string data;

	BOOL alternate;
	int length;
	int last;

	const char * c_str() {return data.c_str();}
	long GetLength()   {return (long)data.size();}
	char GetAt(int i) {return data[i];}
	void SetAt(int i, char c) {data[i] = c;}
	std::string Mid(int start, int len) {return data.substr(start,len);}
	void MakeUpper() {long i = 0, l = (long)data.size(); for (;i != l; ++i) data[i] = toupper(data[i]);}
	long Find(char c) {return (long)data.find(c);}
	long Find(const char * str) {return (long)data.find(str);}
	void operator+=(const char *str) {data += str;}
	void Insert(int p, const char * str) {data.insert(p, str);}


	MString() { };
	MString(const char* in) : data(in) { };
	MString(std::string& in) : data(in) { };
	BOOL SlavoGermanic();
	inline void MetaphAdd(const char* main);
	inline void MetaphAdd(const char* main, const char* alt);
	BOOL IsVowel(int at);
	BOOL StringAt(int start, int length, ... );
	void DoubleMetaphone(std::string &metaph, std::string &metaph2);
};

